import requests , os , json, datetime , time
t_delta = datetime.timedelta(hours=9)
JST = datetime.timezone(t_delta, 'JST')
now = datetime.datetime.now(JST)
PROCESS_DIR = os.path.dirname(os.path.abspath(__file__)) + '/'


class Logger:
  def __init__(self):
    global now
    date = now.strftime('%y%m')
    self.configfile = PROCESS_DIR+f'../log/{date}.log'
  def log(self,msg:str,status:str = "INFO"):
    global JST
    now = datetime.datetime.now(JST)
    date = now.strftime('%y-%m-%d %H:%M:%S')
    text = f'[{date}] : {status} - {msg}'

    print(text)
    with open(self.configfile,'+a',encoding='utf-8') as f:
      f.write(text + ' \n')
LOG = Logger()

class RequestConfig:
  def __init__(self):
    self.access_token = ""
    self.secret_token = ""
    self.domain_name = ""
    self.save_dir = PROCESS_DIR+'../live/'

  def setAccessToken(self,access_token):
    if not access_token:
      raise ValueError("アクセストークンがありません")
    self.access_token = access_token
  
  def getAccessToken(self) -> str:
    return self.access_token
  
  def setSecretToken(self,secret_token):
    if not secret_token:
      raise ValueError("シークレットトークンがありません")
    self.secret_token = secret_token
  
  def getSecretToken(self) -> str:
    return self.secret_token
  
  def setSaveDir(self,save_dir):
    if not save_dir:
      return
    self.save_dir = save_dir
  
  def getSaveDir(self) -> str:
    return self.save_dir
  
  def setDomainName(self,domain_name):
    self.domain_name = domain_name
  def getDomainName(self):
    return self.domain_name
  
class Config:
  def __init__(self):
    self.json = {}
    self.save_dir = PROCESS_DIR + '../live/'
    with open(PROCESS_DIR+'../config.json','r',encoding='utf-8') as f:
      self.json = json.load(f)
    self.json_datas = []

  def read(self):
    reqeust = self.json["request"]
    for req in reqeust:
      request_config = RequestConfig()
      request_config.setAccessToken(req["access_token"])
      request_config.setSecretToken(req["secret_token"])
      request_config.setDomainName(req["domain"])
      save_dir = req["save_dir"]
      parent_save_dir = self.save_dir
      if save_dir and '/' == save_dir[0]:
        parent_save_dir = ""
      request_config.setSaveDir(parent_save_dir + save_dir)
      self.json_datas.append(request_config)
      return self
  
  def get(self) -> list[RequestConfig]:
    return self.json_datas

class GetKey:
  FULLCHAIN = 'fullchain'
  PRIVEKEY = 'privkey'
  def __init__(self,keyType:str = FULLCHAIN):
    self.url = f'https://dns.doliot.net/ssl/get/{keyType}/'
    self.file_data = ""
    self.save_dir = ""
    self.keyType = keyType

  def get(self,request_config : RequestConfig):
    try:
      res = requests.get(self.url+request_config.getAccessToken(),headers={'X-SECRET-TOKEN':request_config.getSecretToken()})
      if res.status_code != 200:
        raise RuntimeError("サーバーエラー")
      
      self.file_data = res.content
      self.save_dir = request_config.getSaveDir()
      return self
    except Exception as e:
      LOG.log(e,'ERROR')

  def save(self,dir_name = ""):
     try:
       os.mkdir(f'{self.save_dir}/{dir_name}/')
     except:
       pass
     try:
      with open(f'{self.save_dir}/{dir_name}/{self.keyType}.pem', 'wb') as saveFile:
          saveFile.write(self.file_data)
      return True
     except:
       return False


request_encript_keys = Config().read()
for re_key in request_encript_keys.get():
  if GetKey(GetKey.FULLCHAIN).get(re_key).save(re_key.getDomainName()):
    log_msg = f'Get {GetKey.FULLCHAIN} key successed for {re_key.getDomainName()}'
    LOG.log(log_msg)
  else:
    log_msg = f'Get {GetKey.FULLCHAIN} key invaild for {re_key.getDomainName()}'
    LOG.log(log_msg,'ERROR')
  if GetKey(GetKey.PRIVEKEY).get(re_key).save(re_key.getDomainName()):
    log_msg = f'Get {GetKey.PRIVEKEY} key successed for {re_key.getDomainName()}'
    LOG.log(log_msg)
  else:
    log_msg = f'Get {GetKey.PRIVEKEY} key invaild for {re_key.getDomainName()}'
    LOG.log(log_msg,'ERROR')
  time.sleep(1)
